#include <SPI.h>
#include "epd_2inch9.h"
#include "Ap_29demo.h"
/***************************************************************************************
 * Project  :
 * Experimental Platform :Arduino Mega 2560 + 2.9inch E-Paper Display
 * Hardware Connection :Arduino Mega 2560-> 2.9inch E-Paper
 *      D53 --> CS
 *      D52 --> CLK
 *      D51 --> MOSI
 *      D8  --> DC
 *      D9  --> RST
 *      D10  --> BUSY
***************************************************************************************/
/******************************
 * 
 * Pin wiring definion
 * VCC---->5V
 * GND---->GND
 * RST---->D9
 * BUSY--->D10
 * D/C---->D8
 * MOSI--->D51
 * CLK---->D52
 * CS----->D53
 * */


void setup() {
  pinMode(BUSY_Pin, INPUT);
  pinMode(RES_Pin, OUTPUT);
  pinMode(DC_Pin, OUTPUT);
  pinMode(CS_Pin, OUTPUT);
  pinMode(SCK_Pin, OUTPUT);
  pinMode(SDI_Pin, OUTPUT);
}

//Tips//
/*
1.When the e-paper is refreshed in full screen, the picture flicker is a normal phenomenon, and the main function is to clear the display afterimage in the previous picture.
2.When the partial refresh is performed, the screen does not flash.
3.After the e-paper is refreshed, you need to put it into sleep mode, please do not delete the sleep command.
4.Please do not take out the electronic paper when power is on.
5.Wake up from sleep, need to re-initialize the e-paper.
6.When you need to transplant the driver, you only need to change the corresponding IO. The BUSY pin is the input mode and the others are the output mode.
*/
void loop() {

  unsigned char i;

  EPD_HW_Init();
  PIC_display(gImage_1);  //EPD_picture0 need 1.5s
  EPD_DeepSleep();        //EPD_DeepSleep,Sleep instruction is necessary, please do not delete!!!
  delay(2000);            //Delay for 2s.
  delay(2000);

  EPD_HW_Init();
  EPD_WhiteScreen_Red();
  EPD_DeepSleep();  //EPD_DeepSleep,Sleep instruction is necessary, please do not delete!!!
  delay(1000);

  EPD_HW_Init();
  EPD_WhiteScreen_Yellow();
  EPD_DeepSleep();  //EPD_DeepSleep,Sleep instruction is necessary, please do not delete!!!
  delay(1000);

  EPD_HW_Init();
  EPD_WhiteScreen_White();
  EPD_DeepSleep();  //Enter deep sleep,Sleep instruction is necessary, please do not delete!!!
  delay(2000);
  while (1)
    ;  // The program stops here
}
